<?php
namespace App\Helpers;

use App\User;
use App\Contact;
use App\ContactTask;
use App\ContactHistory;
use App\ContactBusinessInformation;

use Session;

use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

class UserHelper
{
      const ADMIN_USER     = 1;
      const COMPANY_USER   = 2;
      const CUSTOMER_USER  = 3;
      const RTR_USER       = 4;

      const USER_ACTIVE    = 0;
      const USER_SUSPENDED = 1;

      const ACCESS_TYPE_VIEW_ONLY = 1; //View Only
      CONST ACCESS_TYPE_ALL       = 2; //ACCESS ALL (View, Edit & Delete)

      public static function getRoles() 
      {
            $roles['admin_user'] = array(
                  'dashboard',
                  'companies',
                  'company_users',
                  'user_management',
                        'users',
                        'mca_funders',
                        'groups',
                  'contacts',
                        'history',
                        'advances',
                        'calls',
                        'emails',
                        'notes',
                        'emarketing',
                        'docs',
                        'events',
                        'others',
                              'tasks',
                              'bank_account',
                              'credit_card',
                              'legal_scrub',
                              'special_alert',
                  'contact_datasource',
                  'lenders',
                  'contact_campaigns',
                  'workflow',
                  'email_templates',
                  'reports',
                  'settings',
                  'mail_messaging',
                  'contact_docs',
                  'notifications',
                  'reports',
                        'users_log',
                        'audit_logs',
                        'merchant_logs',
            );

            //this is also the mca funders/user also
            $roles['company_user'] = array(
                  'dashboard',
                  'users',
                  'contacts',
                        'history',
                        'advances',
                        'notes',
                        'events',
                  'contact_docs'
            );

            $roles['customer_user'] = array(
                  'dashboard',
                  'contact_docs',
                  'contact_notes',
                  'contact_task',
                  'contacts',
                  'contact_advance',
                  'mail_messaging'
            );

            $roles['rtr_user'] = array(
                  'dashboard',
                  'companies',
                  'company_users',
                  'user_management',
                        'users',
                        'mca_funders',
                        'groups',
                  'contacts',
                        'history',
                        'advances',
                        'calls',
                        'emails',
                        'notes',
                        'emarketing',
                        'docs',
                        'events',
                        'others',
                              'tasks',
                              'bank_account',
                              'credit_card',
                              'legal_scrub',
                              'special_alert',
                  'contact_datasource',
                  'lenders',
                  'contact_campaigns',
                  'workflow',
                  'email_templates',
                  'reports',
                  'settings',
                  'mail_messaging',
                  'contact_docs',
                  'notifications'
            );           
            
            return $roles; 
      }

      public static function getModulePermissions()
      {
            /*
             * Note: Default to all access (view, edit, create & Delete)
            */

            $permission['admin_user'] = array(
                  'all_access' => TRUE
            );

            $permission['company_user'] = array(
                  'all_access' => FALSE
            );

            $permission['customer_user'] = array(
                  'all_access' => FALSE
            );

            $permission['rtr_user'] = array(
                  'all_access' => TRUE
            );

            return $permission;
      }      

      public static function checkUserRole($group_id = null,$module = null) 
      {
            $with_permission = TRUE;

            $roles = self::getRoles();

            if($group_id == self::ADMIN_USER) {
                  if (!in_array($module, $roles['admin_user'], TRUE)) { 
                        $with_permission = FALSE;
                  } 
            }elseif($group_id == self::COMPANY_USER) {
                  if (!in_array($module, $roles['company_user'], TRUE)) { 
                        $with_permission = FALSE;          
                  } 
            }elseif($group_id == self::CUSTOMER_USER) {
                  if (!in_array($module, $roles['customer_user'], TRUE)) { 
                        $with_permission = FALSE;          
                  }
            }elseif($group_id == self::RTR_USER) {
                  if (!in_array($module, $roles['rtr_user'], TRUE)) { 
                        $with_permission = FALSE;          
                  }
            }

            return $with_permission;
      }

      public static function checkUserRolePermission($group_id = null, $module = null, $function = null, $redirect = false) {
            $with_permission = TRUE;
            $with_access     = FALSE;
            $roles           = self::getRoles();

            if($group_id == self::ADMIN_USER) {
                  if (!in_array($module, $roles['admin_user'], TRUE)) { 
                        $with_permission = FALSE;
                  } 
            }elseif($group_id == self::COMPANY_USER) {
                  if (!in_array($module, $roles['company_user'], TRUE)) { 
                        $with_permission = FALSE;          
                  } 
            }elseif($group_id == self::CUSTOMER_USER) {
                  if (!in_array($module, $roles['customer_user'], TRUE)) { 
                        $with_permission = FALSE;          
                  }
            }elseif($group_id == self::RTR_USER) {
                  if (!in_array($module, $roles['rtr_user'], TRUE)) { 
                        $with_permission = FALSE;          
                  }
            }

            if($with_permission == TRUE) {
                  $function_permission = self::getModulePermissions();

                  if($group_id == self::ADMIN_USER) {
                        if (!in_array($module, $function_permission['admin_user'], TRUE)) { 
                              $all_access = $function_permission['admin_user']['all_access'];   
                              if($all_access) {
                                    $with_access = TRUE;
                              }
                        } 
                  }elseif($group_id == self::COMPANY_USER) {
                        if (!in_array($module, $function_permission['company_user'], TRUE)) { 
                              $all_access = $function_permission['company_user']['all_access'];   
                              if($all_access) {
                                    $with_access = TRUE;
                              }
                        } 
                  }elseif($group_id == self::CUSTOMER_USER) {
                        if (!in_array($module, $function_permission['customer_user'], TRUE)) {  
                              $all_access = $function_permission['customer_user']['all_access'];   
                              if($all_access) {
                                    $with_access = TRUE;
                              }
                        }
                  }elseif($group_id == self::RTR_USER) {
                        if (!in_array($module, $function_permission['rtr_user'], TRUE)) {   
                              $all_access = $function_permission['rtr_user']['all_access'];   
                              if($all_access) {
                                    $with_access = TRUE;
                              }     
                        }
                  }                  
            }      

            if($redirect && !$with_access) {
                  Session::flash('message', 'You have no permission to access the '. $module . ' page.');
                  Session::flash('alert_class', 'alert-danger');                               
            } else {
                  return $with_access;
            }

      }

      public static function isCompanyUser($group_id = null) 
      {
            $return = FALSE;
            if($group_id == self::COMPANY_USER) {
                  $return = TRUE;
            }

            return $return;
      }

      public static function isRTRUser($group_id = null) 
      {
            $return = FALSE;
            if($group_id == self::RTR_USER) {
                  $return = TRUE;
            }

            return $return;
      }

      public static function isAdminUser($group_id = null) 
      {
            $return = FALSE;
            if($group_id == self::ADMIN_USER) {
                  $return = TRUE;
            }

            return $return;
      }   

      public static function customerGroupId()
      {
            return 3;
      }

      public static function clientLoginURL()
      {
            $url = url("/") . "/login";
            return $url;
      }

      public static function resetPasswordURL()
      {
            $url = url("/") . "/reset_password";
            return $url;
      }

      public static function generateRandomString($length = 10, $user_id) 
      {
          $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
          $charactersLength = strlen($characters);
          $randomString = '';
          for ($i = 0; $i < $length; $i++) {
              $randomString .= $characters[rand(0, $charactersLength - 1)];
          }
          return $randomString . $user_id;
      }

      public static function getIdleContacts()
      {
            $status_discharge_id = 28;
            $return     = array();
            $contacts   = Contact::select('id')->whereNotIn('status', array(23,24,25,26,27,28))->get();
            
            $count_idle = 0;
            $idle_data  = array();
            $year_condition = date("Y");
            $contacts_data = array();
            if(!$contacts->isEmpty()) {
                  foreach($contacts as $contact) {
                        $contact_id = $contact['id'];
                        // $contact_history = ContactHistory::where('contact_id','=', $contact_id)
                        //                         ->latest('created_at')
                        //                         ->first();
                        $contact_history = ContactHistory::where('contact_id','=', $contact_id)
                                                ->whereYear('created_at','=',$year_condition)
                                                ->latest('created_at')
                                                ->first();

                        if($contact_history) {
                              
                              $last_activity_date = $contact_history->created_at;

                              if(strtotime($last_activity_date) < strtotime('-15 days')) {
                                    $idle_data[] = $contact_history->toArray();
                                    $contacts_data[] = $contact_history->contact->toArray();
                                    //$return['idle_data'][] = $contact_history->toArray();
                                    $count_idle++;
                              }                              
                        }
                  }
            }

            $return['idle_data']     = $idle_data;
            $return['total_idle']    = $count_idle; 
            $return['contacts_data'] = $contacts_data;

            return $return;
      }

      public static function getTotalUserContactEntry($user_id)
      {
            $total = 0;

            $total_entry = Contact::where('user_id','=', $user_id)
                  ->count();

            if($total_entry > 0) {
                  $total = $total_entry;
            }

            return $total;
      }

      public static function getTodayTotalUserContactEntry($user_id)
      {
            $total = 0;

            $total_entry = Contact::where('user_id','=', $user_id)
                  ->whereDay('created_at', '=', date('d'))
                  ->count();

            if($total_entry > 0) {
                  $total = $total_entry;
            }

            return $total;            
      }

      public static function getTotalUserContactEntryByDate($user_id, $date)
      {
            $total = 0;

            $total_entry = Contact::where('user_id','=', $user_id)
                  ->whereDate('created_at', '=', date('Y-m-d', strtotime($date)))
                  ->count();

            if($total_entry > 0) {
                  $total = $total_entry;
            }

            return $total;            
      }      

      public static function getCompaniesBankrupt( $company_name = '' )
      {
            $status_discharge_id = 28;

            if( $company_name != '' ){
                  $bankruptcy = ContactBusinessInformation::leftJoin('contacts', 'contact_business_informations.contact_id', 'contacts.id')
                  ->leftJoin('companies', function($join){
                        $join->on('companies.id', '=', 'contact_business_informations.company_id');
                  })
                  //->leftJoin('companies', 'contact_business_informations.company_id', 'companies.id')
                  //->where('filed_bankruptcy','=','Yes')
                  ->where('contacts.is_completed', '!=', 1)
                  ->where('contacts.status', '<>', $status_discharge_id)                  
                  //->where('bankruptcy_filed','<=',now()->subMonth(1))
                  ->where('bankruptcy_filed', '>=', date('Y-m-d', strtotime("-30 days")))
                  ->where('bankruptcy_filed','<>','1910-01-01')
                  ->where('contacts.deleted_at', '=', NULL)
                  ->where('companies.deleted_at', '=', NULL)
                  ->where('companies.name', 'like', '%'.$company_name.'%')
                  ->whereIn('contacts.status', array(1,7,13,))
                  ->whereNotIn('status', array(23,24,25,26,27,28))
                  ->get();
            }else{
                  $bankruptcy = ContactBusinessInformation::leftJoin('contacts', 'contact_business_informations.contact_id', 'contacts.id')
                  ->leftJoin('companies', function($join){
                        $join->on('companies.id', '=', 'contact_business_informations.company_id');
                  })
                  //->leftJoin('companies', 'contact_business_informations.company_id', 'companies.id')
                  //->where('filed_bankruptcy','=','Yes')
                  ->where('contacts.is_completed', '!=', 1)
                  ->where('contacts.status', '<>', $status_discharge_id)
                  ->where('contacts.deleted_at', '=', NULL)
                  ->where('companies.deleted_at', '=', NULL)
                  ->where('bankruptcy_filed','<>','1910-01-01')
                  //->where('bankruptcy_filed','<=',now()->subMonth(1))
                  ->where('bankruptcy_filed', '>=', date('Y-m-d', strtotime("-30 days")))
                  ->where('bankruptcy_filed','<>','1910-01-01')
                  ->whereIn('contacts.status', array(1,7,13,))
                  ->whereNotIn('status', array(23,24,25,26,27,28))
                  ->get();
            }
            

            return $bankruptcy;
      }

      public static function getContactsSettled( $company_name = '' )
      {     
            $status_discharge_id = 28;
            if( $company_name != '' ){
                  /*$settled  = Contact::leftJoin('companies', 'contacts.company_id', 'companies.id')->where('is_settled','=','Yes')->where('is_completed','<>',1)->where('status', '<>', $status_discharge_id)->where('date_settled','<=',now()->subMonth(1))->where('companies.name', 'like', '%'.$company_name.'%')->get();*/
                  $settled  = Contact::leftJoin('companies', 'contacts.company_id', 'companies.id')
                        ->where('is_settled','=','Yes')
                        ->where('is_completed','<>',1)
                        ->whereIn('status', array(6,12,18))
                        ->whereNotIn('status', array(23,24,25,26,27,28))
                        //->where('date_settled','<=',Carbon::now()->subDays(5)->toDateTimeString())
                        ->where('date_settled', '>=', date('Y-m-d', strtotime("-5 days")))
                        ->where('companies.name', 'like', '%'.$company_name.'%')
                        ->get();
            }else{
                  /*$settled  = Contact::leftJoin('companies', 'contacts.company_id', 'companies.id')->where('is_settled','=','Yes')->where('is_completed','<>',1)->where('status', '<>', $status_discharge_id)->where('date_settled','<=',now()->subMonth(1))->get();*/
                  $settled  = Contact::where('is_settled','=','Yes')
                        ->where('is_completed','<>',1)
                        ->whereIn('status', array(6,12,18))
                        ->whereNotIn('status', array(23,24,25,26,27,28))
                        //->where('date_settled','<=',Carbon::now()->subDays(5))
                        ->where('date_settled', '>=', date('Y-m-d', strtotime("-5 days")))
                        ->get();
            }
            return $settled;
      }
}
?>