<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use Illuminate\Support\Facades\Auth;

use App\ContactSpecialAlert;

use UserHelper;
use GlobalHelper;

use View;
use Hash;
use Hashids;

use Session;

class ContactSpecialAlertController extends Controller
{
    public function update(Request $request)
    {
        if ($request->isMethod('post'))
        {
            $this->validate($request, [
            	'special_alert_followup_date' => 'required',
                'special_alert_notes' => 'required',
             ]);

            $contact_id = Hashids::decode($request->input('contact_id'))[0]; 
			$contactSpecialAlert   = ContactSpecialAlert::where('contact_id', $contact_id)->first();
			if( $contactSpecialAlert ){
				$contactSpecialAlert->user_id = Auth::user()->id;
				$contactSpecialAlert->follow_up_date = $request->special_alert_followup_date;
				$contactSpecialAlert->notes = $request->special_alert_notes;
				$contactSpecialAlert->save();

				Session::flash('message', 'You have successfully updated contact special alert');
	        	Session::flash('alert_class', 'alert-success');            
			}else{
				$contactSpecialAlert = new ContactSpecialAlert;
				$contactSpecialAlert->user_id = Auth::user()->id;
				$contactSpecialAlert->contact_id = $contact_id;
				$contactSpecialAlert->follow_up_date = $request->special_alert_followup_date;
				$contactSpecialAlert->notes = $request->special_alert_notes;
				$contactSpecialAlert->save();

				Session::flash('message', 'You have successfully created special alert');
	        	Session::flash('alert_class', 'alert-success');            
			} 

            return redirect()->back();	  
        }
    }
}
