<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use \PDO;

use App\Contact;
use App\ContactBusinessInformation;
use App\ContactBrokerInformation;
use App\ContactLoanInformation;
use App\ContactCallTracker;
use App\Workflow;
use App\ContactEvent;
use App\CompanyUser;
use App\EventType;
use App\NoteType;
use App\MailMessaging;
use App\EmailTemplate;
use App\ContactNote;
use App\ContactBankAccount;
use App\ContactCreditCard;
use App\ContactTask;
use App\State;
use App\ContactDocs;
use App\ContactHistory;
use App\ContactAdvance;
use App\ContactUser;
use App\User;
use App\ContactAdvancePayment;
use App\SmsAutomation;
use App\SmsAutomationNumber;

use UserHelper;
use GlobalHelper;
use SmsAutomationHelper;

use View;
use Hash;
use Hashids;

use Session;

class SmsAutomationController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth'); 
        $this->middleware(function ($request, $next) {

            $user_id  = Auth::user()->id;
            $group_id = Auth::user()->group_id;
            // $module   = 'contacts';
            // $with_permission = UserHelper::checkUserRole($group_id, $module); 
            // if(!$with_permission) {
            //     Session::flash('message', 'You have no permission to access the '. $module . ' page.');
            //     Session::flash('alert_class', 'alert-danger');                
            //     return redirect('dashboard');
            // }    

            $pending_task_count = ContactTask::where('assigned_user_id','=', $user_id)->where('status','=', 'pending')->count();
            $pending_task       = ContactTask::where('assigned_user_id','=', $user_id)->where('status','=', 'pending')->get();

            $bankruptcy         = UserHelper::getCompaniesBankrupt();
            $settled            = UserHelper::getContactsSettled();

            $idl_contacts = UserHelper::getIdleContacts();
            $idle_contacts_count = 0;
            $idle_contacts       = array();
            if(!empty($idl_contacts)) {
                $idle_contacts_count = $idl_contacts['total_idle'];
                $idle_contacts       = $idl_contacts['idle_data'];
            }

            View::share ( 'idle_contacts_count', $idle_contacts_count );   
            View::share ( 'idle_contacts', $idle_contacts);             

            View::share ( 'pending_task_count', $pending_task_count );   
            View::share ( 'pending_task', $pending_task); 

            View::share ( 'bankruptcy', $bankruptcy );               
            View::share ( 'settled', $settled );   

            return $next($request);     
        });                 
    }

    public function list(Request $request)
    {
        $user_id      = Auth::user()->id;        
        if(UserHelper::isCompanyUser(Auth::user()->group_id)) {                  
            $smsAutomation = SmsAutomation::where('user_id', $user_id)->paginate(15);
        }else{
            $smsAutomation = SmsAutomation::paginate(15);
        }

        return view('sms_automation.index',['smsAutomation' => $smsAutomation]); 

    } 

    public function create()
    {        
        $user_id      = Auth::user()->id;        
        if(UserHelper::isCompanyUser(Auth::user()->group_id)) {                  
            $contacts = Contact::where('user_id', $user_id)->paginate(15);
        }else{
            $contacts = Contact::paginate(15);
        }

        $optionRuleNotify = SmsAutomation::optionRuleNotifyAt();
        return view('sms_automation.create', [
            'contacts' => $contacts,
            'optionRuleNotify' => $optionRuleNotify
        ]);
    }

    public function store(Request $request)
    {
        if ($request->isMethod('post'))
        {
            $this->validate($request, [
                'automation_name' => 'required',
                'sms_message' => 'required'            
            ]);

            $user_id   = Auth::user()->id;
            $send_date = $this->generateSendDate($request->rule_notify);

            $smsAutomation = new SmsAutomation;
            $smsAutomation->user_id = $user_id;
            $smsAutomation->is_with_error = 0;
            $smsAutomation->automation_name = $request->automation_name;
            $smsAutomation->sms_message = $request->sms_message;
            $smsAutomation->rule_notify_at = $request->rule_notify;
            $smsAutomation->send_date = $send_date;
            $smsAutomation->status = 0;
            $smsAutomation->save();

            $sms_automation_numbers = [];
            if( isset($request->smsContacts) ){
                foreach( $request->smsContacts as $number ){
                    $contact_number  = str_replace("-","",$number);
                    $contact_number  = str_replace(" ","",$contact_number);
                    $sms_automation_numbers[] = [
                        'sms_automation_id' => $smsAutomation->id,
                        'contact_number' => $contact_number,
                        'is_sent' => 0,
                        'is_error' => 0,
                        'error_message' => '',
                        'created_at' => date("Y-m-d H:i:s"),
                        'updated_at' => date("Y-m-d H:i:s")
                    ];
                }
            }            
            
            if( !empty($request->file()) ){
                $file = $request->file('contacts_import');
                $fileContents = file($file->getPathname());

                foreach ($fileContents as $line) {
                    $data = str_getcsv($line);
                    $contact_number  = str_replace("-","",$data[0]);
                    $contact_number  = str_replace(" ","",$contact_number);
                    $sms_automation_numbers[] = [
                        'sms_automation_id' => $smsAutomation->id,
                        'contact_number' => $contact_number,
                        'is_sent' => 0,
                        'is_error' => 0,
                        'error_message' => '',
                        'created_at' => date("Y-m-d H:i:s"),
                        'updated_at' => date("Y-m-d H:i:s")
                    ];
                }
            }            

            if( !empty($sms_automation_numbers) ){
                SmsAutomationNumber::insert($sms_automation_numbers);
            }

            Session::flash('message', 'You have successfully created SMS Automation');
            Session::flash('alert_class', 'alert-success');
            return redirect('sms_automation');

        }else{
            Session::flash('message', 'Unable to create new SMS Automation');
            Session::flash('alert_class', 'alert-danger');  
            return redirect('sms_automation');
        }
    }

    public function generateSendDate($rule_notify)
    {
        $day_week = 'D';
        if (strpos($rule_notify, 'W') !== false) {
            $day_week = 'W';
        }

        $num = (int)$rule_notify;
        if( $day_week == 'D' ){
            if( $num > 0 ){
                $sent_date = date("Y-m-d", strtotime('+ '.$num.' days'));
            }else{
                $sent_date = date("Y-m-d");
            }            
        }else{
            $num = $num * 7;
            $sent_date = date("Y-m-d", strtotime('+ '.$num.' days'));
        }
        
        return $sent_date;
    }

    public function destroy(Request $request)
    {
        if ($request->isMethod('post'))
        {
            $id = $request->input('aid');
            $id = Hashids::decode($id)[0];
            $smsAutomation = SmsAutomation::find($id);

            if($smsAutomation) {  
                $smsAutomationNumbers = SmsAutomationNumber::where('sms_automation_id', $smsAutomation->id)->delete(); 
                $smsAutomation->delete();

                Session::flash('message', "Delete Successful");
                Session::flash('alert_class', 'alert-success');
                return redirect('sms_automation');
            }
        }
    }

    public function update_status(Request $request)
    {
        if ($request->isMethod('post'))
        {
            $id = $request->input('aid');
            $id = Hashids::decode($id)[0];
            $smsAutomation = SmsAutomation::find($id);

            if($smsAutomation) {  
                $smsAutomation->status = $request->status;
                $smsAutomation->save();

                Session::flash('message', "Update Successful");
                Session::flash('alert_class', 'alert-success');
                return redirect('sms_automation');
            }
        }
    }
}
