@extends('layouts.backend.master')

@section('header-php')
  <?php
  $body_id = '';
  $body_class = '';
  ?>
@endsection 

@section('meta-dynamic')
  <title>coreCMS</title>  
  <meta name="description" content="-">    
@endsection

@section('main')
  <!-- Content Header (Page header) -->
  <section class="content-header">
    <h1>
      Notification : Bankruptcy
    </h1>
    
    <!-- 
    <ol class="breadcrumb">
      <li><a href="#"><i class="fa fa-dashboard"></i> Level</a></li>
      <li class="active">Here</li>
    </ol> 
    -->

  </section>

  <!-- Main content -->
    <section class="content container-fluid">

        <!--------------------------
          | Your Page Content Here |
          -------------------------->

        @if(Session::has('message'))
            <div class="alert {{ Session::get('alert_class') }}">
              <button type="button" class="close" data-dismiss="alert">&times</button>
              {{ Session::get('message') }}
            </div>
        @endif    
        
        <div class="row">
            <div class="col-md-12">
              <div class="box">
                <div class="box-body">

                  <div class="row">
                    {{ Form::open(array('url' => 'notification/bankruptcy', 'class' => '', 'method' => 'get')) }}

                      <div class="col-xs-12">
                        <div class="row">
                          <div class="col-md-6">
                            <div class="form-group">
                              <label>Search By: </label><br />
                              <select name="search_by" class="form-control select2" style="width: 30%; float: left;">
                                <option value="name" selected="selected">Company Name</option>
                              </select>
                              <input class="form-control" type="text" value="<?= $search_field; ?>" name="search_field" placeholder="Enter company name" style="width: 70%; float: right;">
                            </div>
                            <!-- /.form-group -->
                          </div>
                          <!-- /.col -->

                          <div class="col-md-6">
                            <div class="form-group">
                              <label>&nbsp;</label><br />
                              <button type="submit" class="btn btn-primary">Search</button>
                              <a class="btn btn-success" href="{{route('notification/bankruptcy')}}">Refresh</a>
                            </div>
                            <!-- /.form-group -->
                          </div>
                        </div>                

                      </div>                      
                    {!! Form::close() !!}         
                  </div>

                  <table class="table table-bordered table-hover">
                    <tr>
                      <th style="width: 1%;" >#</th>
                      <th>Company Name</th>
                      <th style="width:10%;">Bankruptcy Date</th>
                    </tr>
                    <?php $row = 1; ?>
                    @foreach($bankruptcy as $b)
                    <?php if(isset($b->contact->id) && isset($b->company->id)) { ?>       
                      <tr>
                        <td><?= $row; ?></td>
                        <td>
                          <a href="<?php echo url('contact_dashboard/' . Hashids::encode($b->contact->id)) ?>">
                            <?php echo $b->company->name; ?>
                          </a>
                        </td>
                        <td>
                          <?php 
                            if( $b->bankruptcy_filed != '1910-01-01' ){ 
                              echo date("d-M-Y", strtotime($b->bankruptcy_filed));
                            }else{
                              echo "Not set";
                            }
                          ?>
                        </td>
                      </tr>
                    <?php $row++;} ?>
                    @endforeach
                  </table>

                </div>
                <!-- /.box-body -->
              </div>
              <!-- /.box -->
            </div>
            <!-- /.col -->
        </div>
        <!-- /.row -->

    </section>
  <!-- /.content -->
@endsection

