

<?php $__env->startSection('header-php'); ?>
  <?php
  $body_id = '';
  $body_class = '';
  ?>
<?php $__env->stopSection(); ?> 

<?php $__env->startSection('meta-dynamic'); ?>
  <title><?php echo e(config('app.name')); ?></title>  
  <meta name="description" content="-">    
<?php $__env->stopSection(); ?>

<?php $__env->startSection('main'); ?>
<style>
.table .label{
  display:block;
  font-size:12px;
}
.table .btn{
  width:70px;
}
</style>
  <!-- Content Header (Page header) -->
  <section class="content-header">
    <h1>
      SMS Automation
    </h1>
    
    <!-- 
    <ol class="breadcrumb">
      <li><a href="#"><i class="fa fa-dashboard"></i> Level</a></li>
      <li class="active">Here</li>
    </ol> 
    -->

  </section>

  <!-- Main content -->
    <section class="content container-fluid">

        <!--------------------------
          | Your Page Content Here |
          -------------------------->

        <?php if(Session::has('message')): ?>
            <div class="alert <?php echo e(Session::get('alert_class')); ?>">
              <button type="button" class="close" data-dismiss="alert">&times</button>
              <?php echo e(Session::get('message')); ?>

            </div>
        <?php endif; ?>    
        
        <div class="row">
            <div class="col-md-12">
              <div class="box">
                <div class="box-header with-border">
                    <h3 class="box-title">SmS Automation List</h3>
                    <div class="pull-right">
                        <a href="<?php echo e(route('sms_automation/create')); ?>" class="btn btn-primary">
                            <i class="fa fa-plus"></i> Create New
                        </a>
                    </div>
                </div>
                <!-- /.box-header -->

                <div class="box-body">
                  <table class="table table-bordered table-hover">
                    <tr>
                      <th style="width: 40%;">Automation Name</th>
                      <th>Rule Notify</th>
                      <th>Send Date</th>
                      <th style="width: 10%;">Progress</th>
                      <th style="width: 10%;">Status</th>
                      <th style="width:15%;">Action</th>
                    </tr>
                    <tbody>
                      <?php $__currentLoopData = $smsAutomation; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sa): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                          <td><?php echo e($sa->automation_name); ?></td>
                          <td><?php echo e(SmsAutomationHelper::ruleNotifyReadableText($sa->rule_notify_at)); ?></td>
                          <td><?php echo e(date("Y-m-d",strtotime($sa->send_date))); ?></td>
                          <td>
                            <?php $progress = SmsAutomationHelper::getAutomationSentDetails($sa->id); ?>
                            <span><?php echo e($progress['total_sent']); ?>/<?php echo e($progress['total_numbers']); ?></span>
                          </td>
                          <td>
                            <?php if( $sa->status == 0 ){ ?>
                              <span class="label label-info">Inprogress</span>
                            <?php }elseif( $sa->status == 2 ){ ?>
                              <span class="label label-danger">Pause</span>
                            <?php }elseif( $sa->status == 3 ){ ?>
                              <span class="label label-danger">With Errors</span>
                            <?php }else{ ?>
                              <span class="label label-success">Completed</span>
                            <?php } ?>
                          </td>
                          <td>
                              <!-- <a href="<?php echo e(route('sms_automation/edit',[Hashids::encode($sa->id)])); ?>" class="btn btn-xs btn-primary">
                                    <i class="fa fa-edit"></i> Edit
                              </a>  -->
                              <?php if( $sa->status == 0 ){ ?>
                                <a href="javascript:void(0);" class="btn btn-xs btn-danger btn-pause-automation" data-id="<?php echo e(Hashids::encode($sa->id)); ?>" data-name="<?php echo e($sa->automation_name); ?>">
                                    <i class="fa fa-pause"></i> Pause
                                </a> 
                              <?php } ?>
                              <?php if( $sa->status == 2 ){ ?>
                                <a href="javascript:void(0);" class="btn btn-xs btn-info btn-resume-automation" data-id="<?php echo e(Hashids::encode($sa->id)); ?>" data-name="<?php echo e($sa->automation_name); ?>">
                                    <i class="fa fa-play"></i> Resume
                                </a> 
                              <?php } ?>
                              <a href="javascript:void(0);" class="btn btn-xs btn-danger btn-delete-automation" data-id="<?php echo e(Hashids::encode($sa->id)); ?>" data-name="<?php echo e($sa->automation_name); ?>">
                                  <i class="fa fa-trash"></i> Delete
                              </a> 
                          </td>
                        </tr>
                      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                  </table>

                  <div id="modalDeleteAutomaion" class="modal fade bs-example-modal-lg" tabindex="-1" role="dialog" aria-hidden="true" style="text-align: left">
                      <div class="modal-dialog modal-md">
                        <div class="modal-content">

                          <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">×</span>
                            </button>
                            <h4 class="modal-title" id="myModalLabel">Delete</h4>
                          </div>
                          <div class="modal-body"></div>
                          <div class="modal-footer">
                            <?php echo e(Form::open(array('url' => 'sms_automation/destroy'))); ?>

                              <input type="hidden" name="aid" id="aid" value="" />
                              <button type="button" class="btn btn-default" data-dismiss="modal">No</button>
                              <button type="submit" class="btn btn-danger">Yes</button>
                            <?php echo Form::close(); ?>

                          </div>

                        </div>
                      </div>
                  </div>
                  
                  <div id="modalChangeStatusAutomation" class="modal fade bs-example-modal-lg" tabindex="-1" role="dialog" aria-hidden="true" style="text-align: left">
                      <div class="modal-dialog modal-md">
                        <div class="modal-content">

                          <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">×</span>
                            </button>
                            <h4 class="modal-title" id="myModalLabel">Status</h4>
                          </div>
                          <div class="modal-body"></div>
                          <div class="modal-footer">
                            <?php echo e(Form::open(array('url' => 'sms_automation/update_status'))); ?>

                              <input type="hidden" name="aid" id="status-id" value="" />
                              <input type="hidden" name="status" id="change-status" value="" />
                              <button type="button" class="btn btn-default" data-dismiss="modal">No</button>
                              <button type="submit" class="btn btn-info">Yes</button>
                            <?php echo Form::close(); ?>

                          </div>

                        </div>
                      </div>
                  </div>

                </div>
                <!-- /.box-body -->

                <div style="text-align: center;" class="box-footer clearfix">
                    <?php echo e($smsAutomation->links()); ?>

                </div>

              </div>
              <!-- /.box -->
            </div>
            <!-- /.col -->
        </div>
        <!-- /.row -->

    </section>
  <!-- /.content -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('page-footer-scripts'); ?>
<script>
$(function(){
  $('.btn-delete-automation').on('click', function(){
    var automation_id = $(this).attr('data-id');
    var automation_name = $(this).attr('data-name');
    var message = 'Are you sure you want to <b>delete</b> automation <b>'+automation_name+'</b>?'

    $('#aid').val(automation_id);
    $('#modalDeleteAutomaion .modal-body').html(message);
    $('#modalDeleteAutomaion').modal('show');

  });

  $('.btn-pause-automation').on('click', function(){
    var automation_id = $(this).attr('data-id');
    var automation_name = $(this).attr('data-name');    
    var message = 'Are you sure you want to <b>pause</b> automation <b>'+automation_name+'</b>?'

    $('#status-id').val(automation_id);
    $('#change-status').val(2);
    $('#modalChangeStatusAutomation .modal-body').html(message);
    $('#modalChangeStatusAutomation').modal('show');
  });

  $('.btn-resume-automation').on('click', function(){
    var automation_id = $(this).attr('data-id');
    var automation_name = $(this).attr('data-name');    
    var message = 'Are you sure you want to <b>resume</b> automation <b>'+automation_name+'</b>?'

    $('#status-id').val(automation_id);
    $('#change-status').val(0);
    $('#modalChangeStatusAutomation .modal-body').html(message);
    $('#modalChangeStatusAutomation').modal('show');
  });
});
</script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.backend.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/efvyhdmy/public_html/bizboxxcrm-app/resources/views/sms_automation/index.blade.php ENDPATH**/ ?>