

<?php $__env->startSection('header-php'); ?>
  <?php
  $body_id = '';
  $body_class = '';
  ?>
<?php $__env->stopSection(); ?> 

<?php $__env->startSection('meta-dynamic'); ?>
  <title>coreCMS</title>  
  <meta name="description" content="-">    
<?php $__env->stopSection(); ?>

<?php $__env->startSection('main'); ?>
<style>
.multi-select .select2{
  width: 100% !important;
}
</style>
  <!-- Content Header (Page header) -->
  <section class="content-header">
    <h1>
      Contacts Management
    </h1>
    
    <ol class="breadcrumb">
      <li class="active"><a href="#"><i class="fa fa-dashboard"></i> Contacts</a></li>
      <!-- <li class="active">Here</li> -->
    </ol> 

  </section>

  <!-- Main content -->
    <section class="content container-fluid">

        <!--------------------------
          | Your Page Content Here |
          -------------------------->

        <?php if(Session::has('message')): ?>
            <div class="alert <?php echo e(Session::get('alert_class')); ?>">
              <button type="button" class="close" data-dismiss="alert">&times</button>
              <?php echo e(Session::get('message')); ?>

            </div>
        <?php endif; ?>    

        <?php if($errors->any()): ?>
          <div class="alert alert-danger">
            <button type="button" class="close" data-dismiss="alert">&times</button>
            <ul>
              <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <li><?php echo e($error); ?></li>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
          </div><!--/.alert.alert-danger-->
        <?php endif; ?>         
        
        <div class="row">
            <div class="col-md-12">
              <div class="box">
                <div class="box-header with-border">
                    <div class="pull-left">
                        <?php $create_access = UserHelper::checkUserRolePermission(Auth::user()->group_id, 'contacts', 'create');  ?>
                        <?php if($create_access): ?>                      
                          <a href="<?php echo e(route('contact/create')); ?>" class="btn btn-primary">
                              <i class="fa fa-plus"></i> Create New
                          </a>
                        <?php endif; ?>
                    </div>                  
                    <div class="pull-left" style="margin-left: 5px;">
                      <a href="<?php echo e(route('contact_datasource')); ?>" class="btn">
                          <i class="fa fa-database"></i> Data Source
                      </a>          
                    </div>
                    <div class="pull-left" style="margin-left: 5px;">
                      <a href="<?php echo e(route('contact_campaign')); ?>" class="btn">
                          <i class="fa fa-database"></i> Campaigns
                      </a>          
                    </div>
                </div>
                <!-- /.box-header -->

                <div class="box-body">

                  <div class="row">
                    <?php echo e(Form::open(array('url' => 'contact', 'class' => '', 'method' => 'get'))); ?>


                      <div class="col-xs-12">
                        <div class="row">
                          <div class="col-md-6">
                            <div class="form-group">
                              <label>Search By: </label><br />
                              <select name="search_by" class="form-control search_by" style="width: 30%; float: left;">
                                <option <?php echo $search_by == 'name' ? 'selected="selected"' : ''; ?> value="name">Name</option>
                                <option <?php echo $search_by == 'email' ? 'selected="selected"' : ''; ?> value="email">Email</option>
                                <option <?php echo $search_by == 'business_name' ? 'selected="selected"' : ''; ?> value="business_name">Business Name</option>
                                <option <?php echo $search_by == 'assigned_to' ? 'selected="selected"' : ''; ?> value="assigned_to">Assigned To</option>
                              </select>
                              <div class="search-field-container" style="">
                                <input class="form-control search_field" type="text" value="<?php echo $search_field; ?>" name="search_field" placeholder="Default Search" style="width: 70%; float: right;">
                              </div>
                              <div class="dropdown-list-container" style="display: none;">
                                <select disabled="" name="search_field" class="form-control search_field_list" style="width: 70%; float: right;">
                                  <?php $__currentLoopData = $users_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ulist): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                  <option value="<?php echo e($ulist->id); ?>"><?php echo e($ulist->firstname); ?> <?php echo e($ulist->lastname); ?></option>
                                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                              </div>
                            </div>
                            <!-- /.form-group -->
                          </div>
                          <!-- /.col -->

                          <div class="col-md-6">
                            <div class="form-group">
                              <label>&nbsp;</label><br />
                              <button type="submit" class="btn btn-primary">Filter</button>                              
                              <a class="btn btn-success" href="<?php echo e(route('contact')); ?>">Refresh</a>
                              <a class="btn btn-success" href="<?php echo e(route('contact/search_mail_records')); ?>">Search Mail Records</a>
                            </div>
                            <!-- /.form-group -->
                          </div>
                        </div>                
                      </div>                      
                    <?php echo Form::close(); ?>         
                  </div>

                  <table id="table_contact" class="table-striped table-hover table_contact">
                    <thead>
                    <tr>
                      <th>#</th>
                      <th>Created</th>
                      <th>Business Name</th>
                      <th>Assigned To</th>
                      <th>Full Name</th>
                      <th>Home Phone</th>
                      <th>Email</th>
                      <th>Stage</th>
                      <th>Status</th>
                      <th>Source</th>
                      <th>Actions</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php $__currentLoopData = $contact; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $con): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php 
                          $workflow_status = App\Workflow::where('id', '=', $con->status)->first();
                          $business_info   = App\ContactBusinessInformation::where('contact_id', '=', $con->id)->first();

                          $business_name   = '';
                          if( $business_info ){
                            $business_name = $business_info->business_name;
                          }
                          $a_user_list = "";
                          $assigned_user = App\ContactAssignedUser::where('contact_id', '=', $con->id)->get();
                          if(!$assigned_user->isEmpty()) {
                            
                            foreach($assigned_user as $assign_u) {
                              if(isset($assign_u->user->firstname) && isset($assign_u->user->lastname)) {
                                if(isset($assign_u->user->firstname) && isset($assign_u->user->lastname)) {
                                  $a_user_list .= '<span class="label label-success">' . $assign_u->user->firstname . " " . $assign_u->user->lastname . "</span> ";
                                }
                              }
                              
                            }
                          }
                        ?>
                        <tr>
                          <td><?php echo e($con->id); ?></td>                            
                          <td><?php echo e(date("M j, Y", strtotime($con->created_at))); ?></td>
                          <td><?= $business_name; ?></td>
                          <?php if(!empty($a_user_list)): ?>
                            <td><?php echo  $a_user_list; ?></td>
                          <?php else: ?>
                            <td>-</td>
                          <?php endif; ?>
                          <td><a href="<?php echo e(url('contact_dashboard/'.Hashids::encode($con->id))); ?>"><?php echo e($con->firstname); ?> <?php echo e($con->lastname); ?></a></td>
                          <td>
                            <a href="javascript:void(0);" class="btn" id="" onclick="javascript:load_activity_history_tab_list('<?php echo  Hashids::encode($con->id); ?>');" data-toggle="modal" data-target="#modalCallTracker">
                               <?php echo e($con->mobile_number); ?>

                            </a>                                
                          </td>
                          <td>
                            <a href="javascript:void(0);" data-key="<?php echo e($con->email); ?>" data-id="<?php echo e($con->id); ?>" class="btn btn-quick-send-modal" id="" data-toggle="modal" data-target="#modalSendEmail">
                              <?php echo e($con->email); ?>

                            </a>
                          </td>
                          <td><?php echo e(!empty($con->stage->name) ? $con->stage->name : '-'); ?></td>
                          <td><?php echo e(!empty($workflow_status->status) ? $workflow_status->status : '-'); ?></td>
                          <td><?php echo e(isset($con->data_source) ? $con->data_source : 'Form Fill'); ?></td>
                          <td>
                              <a href="javascript:void(0);" class="btn btn-xs btn-danger" data-toggle="modal" data-target="#modalDelete-<?= $con->id; ?>" >
                                  <i class="fa fa-trash"></i> Delete
                              </a>
                              <?php $edit_access = UserHelper::checkUserRolePermission(Auth::user()->group_id, 'contacts', 'edit');  ?>
                              <?php if($edit_access): ?>                                
                                <a href="<?php echo e(route('contact/edit',[Hashids::encode($con->id)])); ?>" class="btn btn-xs btn-primary">
                                    <i class="fa fa-edit"></i> Edit
                                </a> 
                              <?php endif; ?>
                              <a href="javascript:void(0);" class="btn btn-xs btn-primary" onclick="javascript:load_update_status_field('<?php echo $con->id; ?>')" id="edit-modal-status-<?php echo $con->id; ?>" data-toggle="modal" data-target="#modalEdit">
                                  <i class="fa fa-edit"></i> Status
                              </a>                                                            
                          </td>
                        </tr>

                        <div id="modalDelete-<?= $con->id; ?>" class="modal fade bs-example-modal-lg" tabindex="-1" role="dialog" aria-hidden="true" style="text-align: left">
                            <div class="modal-dialog modal-md">
                              <div class="modal-content">

                                <div class="modal-header">
                                  <button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">×</span>
                                  </button>
                                  <h4 class="modal-title" id="myModalLabel">Delete</h4>
                                </div>
                                <div class="modal-body">
                                  Are you sure you want to delete selected contact?
                                </div>
                                <div class="modal-footer">
                                  <?php echo e(Form::open(array('url' => 'contact/destroy'))); ?>

                                    <?php echo Form::hidden('id', Hashids::encode($con->id) ,[]); ?>
                                    <button type="button" class="btn btn-default" data-dismiss="modal">No</button>
                                    <button type="submit" class="btn btn-danger">Yes</button>
                                  <?php echo Form::close(); ?>

                                </div>

                              </div>
                            </div>
                        </div>   

                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                  </table>

                  <div id="modalEdit" class="modal fade bs-example-modal-lg" tabindex="-1" role="dialog" aria-hidden="true" style="text-align: left">
                      <?php echo e(Form::open(array('url' => 'contact/update_status', 'class' => '', 'id' => 'edit-contact-status-form'))); ?>

                        <div class="modal-dialog modal-md">
                          <div class="modal-content">

                            <div class="modal-header">
                              <button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">×</span>
                              </button>
                              <h4 class="modal-title" id="myModalLabel">Edit Status</h4>
                            </div>
                            <div class="modal-body">
                              <div id="stage-status-container"></div>
                            </div>
                            <div class="modal-footer">
                              <?php if(UserHelper::checkUserRolePermission(Auth::user()->group_id, 'contacts', 'edit')): ?>
                                <button type="submit" class="btn btn-default">Update</button>
                              <?php endif; ?>
                              <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                            </div>

                          </div>
                        </div>
                      <?php echo Form::close(); ?>        
                  </div>

                  <div id="modalCallTracker" class="modal fade bs-example-modal-lg" tabindex="-1" role="dialog" aria-hidden="true" style="text-align: left">                     
                      <?php echo e(Form::open(array('url' => 'contact_call_tracker/store', 'class' => '', 'id' => 'call-log-activity-form'))); ?>

                        <input type="hidden" value="" name="contact_id" id="contact_id" class="contact_id_add_modal">
                        <div class="modal-dialog modal-lg" style="width: 1000px !important;">
                          <div class="modal-content">

                            <div class="modal-header">
                              <button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">×</span>
                              </button>
                              <h4 class="modal-title" id="myModalLabel">Call Log Activity</h4>
                            </div>
                            <div class="modal-body">

                              <div class="row">
                              <section class="col-lg-5 connectedSortable ui-sortable">
                                <?php echo e(Form::open(array('url' => 'contact_call_tracker/store', 'class' => '', 'id' => 'add-call-tracker'))); ?>

                                <div class="row">

                                  <div class="col-xs-3">
                                    <div class="form-group">
                                      <label for="inputcalltype">Type</label>
                                      <select name="call_type" id="call_type" class="form-control">
                                        <option value="Outgoing">Outgoing</option>
                                        <option value="Incoming">Incoming</option>
                                      </select>  
                                    </div>                
                                  </div>
                                  <div class="col-xs-4">
                                    <div class="form-group">
                                      <label for="inputAssignedUser">Call Result</label>
                                      <select name="call_result" id="call_result" class="form-control">
                                        <option value="Already in Program">Already in Program</option>
                                        <option value="Busy">Busy</option>
                                        <option value="Connected">Connected</option>
                                        <option value="Disconnected">Disconnected</option>
                                        <option value="Do Not Contact">Do Not Contact</option>
                                        <option value="Hang Up">Hang Up</option>
                                        <option value="Left Message">Left Message</option>
                                        <option value="No Answer">No Answer</option>
                                        <option value="Wrong Number">Wrong Number</option>
                                      </select>                   
                                    </div>                
                                  </div>

                                  <div class="col-xs-2">
                                    <div class="form-group">
                                      <label for="inputTime">Time</label>
                                      <input type="text" class="form-control" id="call_minutes" name="call_minutes" placeholder="Call Minutes" title="Call Minutes" required="">
                                    </div>                
                                  </div>

                                  <div class="col-xs-2">
                                    <div class="form-group">
                                      <label for="inputTime">&nbsp;</label>
                                      <input type="text" class="form-control" id="call_seconds" name="call_seconds" placeholder="Call Seconds" title="Call Seconds" required="">
                                    </div>                
                                  </div>

                                </div>

                                <div class="row">
                                  <div class="col-xs-12">
                                    <div class="form-group">
                                      <label for="inputNoteAboutThisCall">Notes about this call</label>
                                      <textarea rows="4" cols="50" class="form-control" id="notes" name="notes" required=""></textarea>
                                    </div>
                                  </div>
                                </div>

                                <div class="row"><div class="col-xs-12"><label>Event Type for this call update status</label></div></div>

                                <div class="row">

                                  <div class="col-xs-6">
                                    <div class="form-group">
                                      <select name="event_type_id" id="event_type_id" class="form-control">
                                        <?php $__currentLoopData = $event_types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $event_type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                          <option value="<?php echo e($event_type->id); ?>"><?php echo e($event_type->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                      </select>  
                                    </div>                
                                  </div>
                                  <div class="col-xs-5">
                                    <div class="form-group">
                                      <select name="call_update_status" id="call_update_status" class="form-control">
                                        <option value="Opened">Opened</option>
                                        <option value="Completed">Completed</option>
                                        <option value="Cancelled">Cancelled</option>
                                        <option value="Dispatched">Dispatched</option>
                                      </select>                   
                                    </div>                
                                  </div>

                                </div>    

                                <div class="row">
                                  <div class="col-xs-12">
                                    <div class="form-group">
                                      <button type="submit" class="btn btn-default">Add</button>
                                      <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button> 
                                    </div>  
                                  </div>                               
                                </div>    
                                <?php echo Form::close(); ?>                     
                              </section>

                              <section class="col-lg-7 connectedSortable ui-sortable">

                              <?php if(Session::has('message')): ?>
                                  <div class="alert <?php echo e(Session::get('alert_class')); ?>">
                                    <button type="button" class="close" data-dismiss="alert">&times</button>
                                    <?php echo e(Session::get('message')); ?>

                                  </div>
                              <?php endif; ?>    

                              <?php if($errors->any()): ?>
                                <div class="alert alert-danger">
                                  <button type="button" class="close" data-dismiss="alert">&times</button>
                                  <ul>
                                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li><?php echo e($error); ?></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                  </ul>
                                </div><!--/.alert.alert-danger-->
                              <?php endif; ?>   

                                <div class="nav-tabs-custom contact-dashboard">
                                  <ul class="nav nav-tabs">
                                    <li class="active"><a href="#tab_activity_history" data-toggle="tab">Activity History</a></li>
                                    <li class=""><a href="#tab_followup_call" data-toggle="tab">Followup Call</a></li>              
                                  </ul>

                                  <div class="tab-content">
                                    <div class="active tab-pane" id="tab_activity_history">

                                      <div id="activity-history-tab-list-container"></div>

                                      <div style="text-align: center;" class="box-footer clearfix">

                                      </div>
      
                                    </div>
                                    
                                    <div class="tab-pane" id="tab_followup_call">
                                      <?php echo e(Form::open(array('url' => 'contact_call_tracker/store_followup', 'class' => '', 'id' => 'call-log-followup-form'))); ?>

                                      <input type="hidden" name="event_date" id="event_date" class="event_date" value="">
                                      <input type="hidden" name="contact_id" id="contact_id" class="contact_id" value="">
                                      <div class="row">
                                        <section class="col-lg-7 connectedSortable ui-sortable" style="text-align: center;">
                                          <label for="inputNoteAboutThisCall">When</label>
                                          <div class="when-calendar"></div>
                                        </section>
                                        <section class="col-lg-5 connectedSortable ui-sortable">
                                          <div class="row">
                                            <div class="col-xs-12">
                                              <div class="form-group">
                                                <label for="inputNoteAboutThisCall">Assigned to: </label>
                                                <div id="user-assigned-to-container" class="user-assigned-to-container"></div>                                                 
                                              </div>
                                            </div>
                                          </div>
                                          <div class="row">
                                            <div class="col-xs-12">
                                              <div class="form-group">
                                                <label for="inputNoteAboutThisCall">Event Type </label>
                                                <select name="event_type_id" id="event_type_id" class="form-control">
                                                  <?php if( !empty($event_types->toArray()) ): ?>
                                                    <?php $__currentLoopData = $event_types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $et): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>   
                                                      <option value="<?php echo e($et->id); ?>"><?php echo e($et->name); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                  <?php else: ?>
                                                    <select name="event_type_id" id="event_type_id" class="form-control">
                                                      <option value="">No event type available</option>
                                                    </select>
                                                  <?php endif; ?>
                                                </select>                                                  
                                              </div>
                                            </div>
                                          </div>
                                          <div class="row">
                                            <div class="col-xs-12">
                                              <div class="form-group">
                                                <label for="inputNoteAboutThisCall">Time: </label>
                                                <input type="text" name="event_time" id="event_time" class="form-control timepicker" value="">                                                 
                                              </div>
                                            </div>
                                          </div>                                          
                                          <div class="row">
                                            <div class="col-xs-12">
                                              <div class="form-group">
                                                <textarea rows="4" cols="50" class="form-control" id="description" name="description" required=""></textarea>
                                              </div>
                                            </div>
                                          </div>
                                          <div class="row">
                                            <div class="col-xs-12">
                                              <div class="form-group">
                                                <button type="submit" class="btn btn-default">Save Call</button>
                                                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>                                                                                           
                                              </div>
                                            </div>
                                          </div>                                           
                                        </section>                                          
                                      </div>
                                      <?php echo Form::close(); ?>        
                                    </div>
                                  </div>                                 
                                </div>
                              </section>
                              </div>

                            </div>

                            <!-- <div class="modal-footer">
                              <button type="submit" class="btn btn-default" disabled>Add</button>
                              <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                            </div> -->

                          </div>
                        </div>
                      <?php echo Form::close(); ?>        
                  </div>                  

                </div>
                <!-- /.box-body -->

                <div style="text-align: center;" class="box-footer clearfix">
                    
                    <?php echo e($contact->appends(request()->input())->links()); ?>

                </div>

              </div>
              <!-- /.box -->
            </div>
            <!-- /.col -->
        </div>
        <!-- /.row -->

    </section>

    <div id="modalSendEmail" class="modal fade bs-example-modal-lg" tabindex="-1" role="dialog" aria-hidden="true" style="text-align: left">
        <?php echo e(Form::open(array('url' => 'mail_messaging/send', 'class' => '', 'id' => 'send-email-form'))); ?>

          <div class="modal-dialog modal-lg">
            <div class="modal-content">
          <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">×</span>
            </button>
            <h4 class="modal-title" id="myModalLabel">Send Email</h4>
          </div>
                <div class="modal-body">
            <div class="form-group multi-select row">
              <label class="col-sm-2 col-form-label">To <span class="required"></span></label>
              <div class="col-sm-10">
                <select class="select_recipient_to form-control" name="recipient[]" multiple="multiple">
                  <?php $__currentLoopData = $contacts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($c->id); ?>"><?php echo e($c->email); ?></option>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>                                
              </div>
            </div>
            <div class="form-group multi-select row">
              <label class="col-sm-2 col-form-label">BCC <span class="required"></span></label>
              <div class="col-sm-10">
                <select class="select_recipient form-control" name="bcc[]" multiple="multiple">
                  <?php $__currentLoopData = $contacts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($c->email); ?>"><?php echo e($c->email); ?></option>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>                                 
              </div>
            </div>
            <div class="form-group multi-select row">
              <label class="col-sm-2 col-form-label">CC <span class="required"></span></label>
              <div class="col-sm-10">
                <select class="select_recipient form-control" name="cc[]" multiple="multiple">
                  <?php $__currentLoopData = $contacts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($c->email); ?>"><?php echo e($c->email); ?></option>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>                                 
              </div>
            </div> 
            <div class="form-group row">
              <label class="col-sm-2 col-form-label">Subject <span class="required"></span></label>
              <div class="col-sm-10">
                <?php echo Form::text('subject', old('subject') ,['class' => 'form-control']); ?>
              </div>
            </div>
            <div class="form-group row">
              <label class="col-sm-2 col-form-label">Email Templates</label>
              <div class="col-sm-10">
                <select class="form-control email-template" name="">
                    <option value="0">- Blank -</option>
                  <?php $__currentLoopData = $emailTemplates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $et): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($et->id); ?>"><?php echo e($et->name); ?></option>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>                                 
              </div>
            </div>
            <div class="form-group">
              <label>Message <span class="required">*</span></label>
              <div class="editor-container">
                <?php echo Form::textarea('content', old('content') ,['id' => 'ckeditor', 'class' => 'form-control', 'required' => '']); ?>
              </div>
            </div>
                </div>
              <div class="modal-footer">
                <button type="submit" class="btn btn-default">Send</button>
                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
              </div>

            </div>
          </div>
        <?php echo Form::close(); ?>        
    </div>
  <!-- /.content -->
<?php $__env->stopSection(); ?>

<?php 
  $call_track_modal = 'no';
  if ($errors->any()) {
    $call_track_modal = 'yes';
  }
?>

<?php $__env->startSection('page-footer-scripts'); ?>
<script>
  var base_url = '<?php echo url("/"); ?>';

  function load_update_status_field(id) {
    $('#stage-status-container').html('<br /><div style="text-align: center;" class="wrap"><i class="fa fa-spin fa-spinner"></i> Loading</div><br />');
    var url = base_url + '/contact/ajax_load_update_status'
    $.ajax({
         type: "GET",
         url: url,               
         data: {"id":id}, 
         success: function(o)
         {
            $('#stage-status-container').html(o);
         }
    });
  }  

  function load_assigned_to_users(id) {
    $('#user-assigned-to-container').html('<br /><div style="text-align: center;" class="wrap"><i class="fa fa-spin fa-spinner"></i> Loading</div><br />');
    var url = base_url + '/contact_call_tracker/ajax_followup_call_user_dropdown'
    $.ajax({
         type: "GET",
         url: url,               
         data: {"id":id}, 
         success: function(o)
         {
            $('#user-assigned-to-container').html(o);
         }
    });    
  }

  function load_activity_history_tab_list(id) {
    load_assigned_to_users(id);
    $('#activity-history-tab-list-container').html('<br /><div style="text-align: center;" class="wrap"><i class="fa fa-spin fa-spinner"></i> Loading</div><br />');
    $('.contact_id_add_modal').val(id);
    $('.contact_id').val(id);
    var url = base_url + '/contact_call_tracker/ajax_loadactivity_history_tab_list'
    $.ajax({
         type: "GET",
         url: url,               
         data: {"id":id}, 
         success: function(o)
         {
            $('#activity-history-tab-list-container').html(o);
         }
    });  
  }

  function loat_default_search_value() {
      var search_by_value = $('.search_by').val();
      if(search_by_value == 'assigned_to') {
        $(".search-field-container").hide();
        $(".dropdown-list-container").show();

        $('.search_field_list').removeAttr("disabled");
        $('.search_field').attr('disabled', true);
      } else {
        $(".search-field-container").show();
        $(".dropdown-list-container").hide();

        $('.search_field').removeAttr("disabled");
        $('.search_field_list').attr('disabled', true);
      }
  }

  $(function () { 

    loat_default_search_value();

    $('.select_recipient').select2();
    $('.select_recipient_to').select2();
    $('.search_field_list').select2();
    
    $(".btn-quick-send-modal").click(function(){
      var email_selected = $(this).attr("data-key");
      var contact_id = $(this).attr("data-id");
      $(".select_recipient_to").select2("val", contact_id);
      //$('.select_recipient_to').select2('data', {id: 11, text: 'test@test.com'});      
    }); 

    $(".email-template").change(function(){
      var email_template_id = $(this).val();
      $('.editor-container').html('<br /><div style="text-align: center;" class="wrap"><i class="fa fa-spin fa-spinner"></i> Loading</div><br />');
      var url = base_url + '/email_template/ajax_load_email_template_content';
      $.ajax({
           type: "GET",
           url: url,               
           data: {
              "email_template_id":email_template_id
              }, 
           success: function(o)
           {
              $('.editor-container').html(o);
           }
      });
    });

    <?php if(Session::get('calltrackermodal') == 'yes') { ?>
      load_activity_history_tab_list('<?php echo Session::get('calltrackercontactid'); ?>'); 
      $('#modalCallTracker').modal('show'); 
    <?php }elseif($call_track_modal == 'yes') { ?>
      load_activity_history_tab_list('<?php echo Session::get('calltrackercontactid'); ?>'); 
      $('#modalCallTracker').modal('show');
    <?php } ?>

    $('.when-calendar').pignoseCalendar({
      theme: 'blue',
      select: function(date) {
        $('#event_date').val(date[0]);
      }
    }); 

    $('.timepicker').timepicker({
      showInputs: false
    })       

    CKEDITOR.replace('ckeditor');

    //$('#table_contact').DataTable();
    $('#table_contact').DataTable({
      'paging'      : false,
      'lengthChange': false,
      'searching'   : false,
      'ordering'    : true,
      'info'        : false,
      'autoWidth'   : true
    })    

    $( ".search_by" ).change(function() {
      var search_by_value = $('.search_by').val();
      if(search_by_value == 'assigned_to') {
        $(".search-field-container").hide();
        $(".dropdown-list-container").show();

        $('.search_field_list').removeAttr("disabled");
        $('.search_field').attr('disabled', true);
      } else {
        $(".search-field-container").show();
        $(".dropdown-list-container").hide();

        $('.search_field').removeAttr("disabled");
        $('.search_field_list').attr('disabled', true);
      }
    });    
    
  });
  
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.backend.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/efvyhdmy/public_html/bizboxmca-app/resources/views/contact/index.blade.php ENDPATH**/ ?>